<?php
	
	/*
	MGB 0.6 Alpha 2 - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2007 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// =============== //
	// index.php - 1.0 //
	// =============== //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// load config, settings and language files
	include ("config.php");
	include ("load_settings.php");
	include ("language/".$settings['language_path']."/lang_main.php");
	// load templates
	include ("load_templates.php");

	// set number of site to "1" if it is "0"
	if($_GET[p] == NULL) { $_GET[p] = 1; }	

	// connect to database
	$link = @mysql_connect($db[host], $db[username], $db[password]) or die ("(index.php, error connecting to database) Error: ".mysql_error());
	@mysql_select_db($db[dbname], $link) or die ("(index.php, error selecting table) Error: ".mysql_error());

	// get total number of entries
	$link_count = "SELECT COUNT(ID) FROM $db[entries] WHERE CHECKED=1";
	$results = @mysql_query($link_count) or die ("(index.php, query error) Error: ".mysql_error());
	$total = @mysql_result($results, 0);

	// compute how many pages there are
	$p = ($total / $settings['entries_per_page']);	

	if ($p <= 1)
		{
		$p = 0;
		if ($total > 1)
			{
			$how_many_entries = $total."&nbsp;".$lang['entries'];
			}
		elseif ($total == 0)
			{
			$how_many_entries = $lang['no_entries'];
			}
		else
			{
			$how_many_entries = $total."&nbsp;".$lang['entry'];
			}
		}
	else
		{
		$p = ceil($p);
		$how_many_entries = $total."&nbsp;".$lang['entries_on_pages'];
		}

	$load_start = ($_GET[p] * $settings['entries_per_page']) - $settings['entries_per_page'];
	$load_end = $settings['entries_per_page'];

	if ($_GET[p] == 1) { $scrolling_function = $_GET[p]."&nbsp;-&nbsp;<a href=\"index.php?p=".($_GET[p] + 1)."\" title=\"".$lang['page_forwards']."\">&raquo;</a>"; }
	if ($_GET[p] > 1) { $scrolling_function = "<a href=\"index.php?p=".($_GET[p] - 1)."\" title=\"".$lang['page_backwards']."\">&laquo;</a>&nbsp;-&nbsp;".$_GET[p]."&nbsp;-&nbsp;<a href=\"index.php?p=".($_GET[p] + 1)."\" title=\"".$lang['page_forwards']."\">&raquo;</a>"; }
	if ($_GET[p] == $p) { $scrolling_function = "<a href=\"index.php?p=".($_GET[p] - 1)."\" title=\"".$lang['page_backwards']."\">&laquo;</a>&nbsp;-&nbsp;".$_GET[p]; }	
	if ($p <= 0) { $content_scrolling_function = "<br>"; }

	// load guestbook entries
	$sql = "SELECT * FROM $db[entries] WHERE checked=1 ORDER BY ID DESC LIMIT $load_start, $load_end";
	$result = @mysql_query($sql, $link) or die ("(index.php. query error) Error: ".mysql_error());

	for($i = 0; $i < mysql_num_rows($result); $i++)
		{		
		$entry[$i] = mysql_fetch_array($result);
		}	

	// fill header template with content
	$refresh = "";
	$page_header = $content_header;
	$page_header = preg_replace("/\{H_LANGUAGE_SHORT\}/", $language_short, $page_header);
	$page_header = preg_replace("/\{H_DOMAIN\}/", $settings['h_domain'], $page_header);
	$page_header = preg_replace("/\{H_AUTHOR\}/", $settings['h_author'], $page_header);
	$page_header = preg_replace("/\{H_KEYWORDS\}/", $settings['h_keywords'], $page_header);
	$page_header = preg_replace("/\{H_DESCRIPTION\}/", $settings['h_description'], $page_header);
	$page_header = preg_replace("/\{H_CHARSET\}/", $charset, $page_header);
	$page_header = preg_replace("/\{REFRESH\}/", $refresh, $page_header);

	// fill entry template with content
	include ("functions.php");
	
	$entry_counter = ($settings['entries_per_page'] * $_GET[p]) - $settings['entries_per_page'];

	for($i = 0; $i < count($entry); $i++)
         	{
		$page_entry[$i] = $content_index_entry;		
		$entry_counter++;				

		// wordwrap: if message contains words longer than $settings['wordwrap'] they will
		// be broken into two or more strings. If $settings['wordwrap'] == 0, function is off
		// this method taken from http://de.php.net/manual/en/function.wordwrap.php#64517
		// will luckily not break html tags
		if (!$settings['wordwrap'] == 0)
			{
			//$entry[$i][message] = wordwrap($entry[$i][message], $settings['wordwrap'], "<br />", 1);
			$entry[$i][message] = textWrap($entry[$i][message], $settings['wordwrap']);
			}

		// set smilies
		if ($settings['smileys'] == 1)
			{
			$entry[$i][message] = set_smilies($entry[$i][message], "templates/".$settings['template_path']);
			$entry[$i][comment] = set_smilies($entry[$i][comment], "templates/".$settings['template_path']);
			}
		else
			{
			$entry[$i][message] = delete_smilies($entry[$i][message]);
			$entry[$i][comment] = delete_smilies($entry[$i][comment]);
			}

		// set bbcode
		if($settings['bbcode'] == 1)
			{
			$entry[$i][message] = bbcode_format($entry[$i][message]);
			$entry[$i][comment] = bbcode_format($entry[$i][comment]);
			}
		else
			{
			$entry[$i][message] = bbcode_delete($entry[$i][message]);
			$entry[$i][comment] = bbcode_delete($entry[$i][comment]);
			}

		// find out which optional data has been set by the user
		$email = $content_index_entry_email;
		$city = $content_index_entry_city;
		$hp = $content_index_entry_hp;
		$icq = $content_index_entry_icq;
		$aim = $content_index_entry_aim;
		$msn = $content_index_entry_msn;
		$comment = $content_index_entry_comment;

		if ($entry[$i][city] == "") { $city = ""; }
		if ($entry[$i][hp] == "") { $hp = ""; }
		if ($entry[$i][icq] == "") { $icq = ""; }
		if ($entry[$i][aim] == "") { $aim = ""; }
		if ($entry[$i][msn] == "") { $msn = ""; }
		if ($entry[$i][comment] == "") { $comment = ""; }

		// find out if the user wants his email to be shown
		if ($entry[$i][user_show_email] != 0)
			{
			if ($settings['spam_protection'] == 1)
				{
				$entry_email_path = "email.php?id=".$entry[$i][ID];
				$entry_email_pic = "/images/email.png";
				$entry_email_text = $lang['email_yes'];
				}
			else
				{
				$entry_email_path = "mailto:".$entry[$i][email];
				$entry_email_pic = "/images/email.png";
				$entry_email_text = $lang['email_yes'];
				}
			}
		else
			{
			$entry_email_path = "email.php?id=denied";
			$entry_email_pic = "/images/email_error.png";
			$entry_email_text = $lang['email_no'];
			}
			
		if (!$settings['badwords'] == NULL)
			{
			// replace badwords
			$badwords = explode(',', $settings['badwords']);
			foreach($badwords as $key => $val)
			$badwords[$key] = trim($val);
		
			$entry[$i][name] = badwords($entry[$i][name]);
			$entry[$i][city] = badwords($entry[$i][city]);
			$entry[$i][message] = badwords($entry[$i][message]);
			}

		// convert timestamp in mgb format
		$timestamp = explode(' ', $entry[$i][timestamp]);
		$date = $timestamp[0];
		$time = $timestamp[1];
		$date = explode('-', $date);
		$date = $date[2]."/".$date[1]."/".$date[0];
		$time = explode(':', $time);
		$time = $time[0].":".$time[1];
		$timestamp = $date."&nbsp;".$lang['at']."&nbsp;".$time."&nbsp;".$lang['oclock'];

		// fill template with other templates if set
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_CITY\}/", $city, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_EMAIL\}/", $email, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_HP\}/", $hp, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_ICQ\}/", $icq, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_AIM\}/", $aim, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_MSN\}/", $msn, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_ENTRY_COMMENT\}/", $comment, $page_entry[$i]);

		// fill template with entry (language)
		$page_entry[$i] = preg_replace("/\{LANG_FROM\}/", $lang['from'], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{LANG_EMAIL_OF\}/", $entry_email_text, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{LANG_HP_OF\}/", $lang['hp_of'], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{LANG_COMMENT\}/", $lang['comment'], $page_entry[$i]);

		// fill template with entry (strings)
		$page_entry[$i] = preg_replace("/\{ENTRY_ID\}/", $entry_counter, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_ANCHOR\}/", "<a href=\"index.php?p=".$_GET[p]."#e".$entry_counter."\" title=\"".$lang['anchor']."\">&raquo;</a>", $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_NAME\}/", $entry[$i][name], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_CITY\}/", $entry[$i][city], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_EMAIL_PIC\}/", $entry_email_pic, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_EMAIL_PATH\}/", $entry_email_path, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_TIMESTAMP\}/", $timestamp, $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_MESSAGE\}/", $entry[$i][message], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_HP\}/", $entry[$i][hp], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_ICQ_NUMBER\}/", $entry[$i][icq], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_AIM_NAME\}/", $entry[$i][aim], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_MSN\}/", $entry[$i][msn], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{ENTRY_COMMENT\}/", $entry[$i][comment], $page_entry[$i]);
		$page_entry[$i] = preg_replace("/\{TEMPLATE_PATH\}/", "templates/".$settings['template_path'], $page_entry[$i]);
		$page_entry_echo .= $page_entry[$i];
		}

	// footer
	$page_footer = $content_footer;

	// fill body_index.tpl
	$page_body_index = $content_index_body;
	$page_body_index = preg_replace("/\{HEADER\}/", $page_header, $page_body_index);
	$page_body_index = preg_replace("/\{TITLE\}/", $settings['title'], $page_body_index);
	$page_body_index = preg_replace("/\{LANG_NEW_ENTRY\}/", "<a href=\"newentry.php\" title=\"".$lang['new_entry_descr']."\">".$lang['new_entry']."</a>", $page_body_index);
	$page_body_index = preg_replace("/\{LANG_CONTACT\}/", "<a href=\"email.php?id=admin\" title=\"".$lang['contact_descr']."\">".$lang['contact']."</a>", $page_body_index);
	$page_body_index = preg_replace("/\{LANG_ADMINPANEL\}/", "<a href=\"admin/admin.php\" title=\"".$lang['adminpanel_descr']."\">".$lang['adminpanel']."</a>", $page_body_index);
	$page_body_index = preg_replace("/\{LANG_HOW_MANY_ENTRIES\}/", $how_many_entries, $page_body_index);
	$page_body_index = preg_replace("/\{PAGES\}/", $p, $page_body_index);
	$page_body_index = preg_replace("/\{TEMPLATE_SCROLLING_FUNCTION\}/", $content_scrolling_function, $page_body_index);
	$page_body_index = preg_replace("/\{SCROLLING_FUNCTION\}/", $scrolling_function, $page_body_index);
	$page_body_index = preg_replace("/\{TEMPLATE_ENTRIES\}/", $page_entry_echo, $page_body_index);
	$page_body_index = preg_replace("/\{TEMPLATE_COPYRIGHT\}/", $content_copyright, $page_body_index);
	$page_body_index = preg_replace("/\{TEMPLATE_FOOTER\}/", $page_footer, $page_body_index);
	$page_body_index = preg_replace("/\{MGB_VERSION\}/", $settings['version'], $page_body_index);
	$page_body_index = preg_replace("/\{TEMPLATE_PATH\}/", "templates/".$settings['template_path'], $page_body_index);

	// generate page
	echo $page_body_index;
?>